/*
 * Testing.cpp
 *
 *  Created on: Dec 4, 2013
 *      Author: nino
 */

#include <Testing.h>

#define PRINT_TESTING_OPTION 1

int test_clear_realization_with_vector(){

	int n = 10;
	igraph_dqueue_t q_infected_nodes_all;
	igraph_dqueue_init(&q_infected_nodes_all, n);

	igraph_vector_t realization_star;
	igraph_vector_init ( &realization_star, n);

	if (PRINT_TESTING_OPTION) {
		print_realization_vector(&realization_star, n);
	}

	int x;

	x = 5;
	igraph_dqueue_push(&q_infected_nodes_all, (igraph_real_t) x);
	VECTOR(realization_star)[ x ] = 1;

	x = 8;
	igraph_dqueue_push(&q_infected_nodes_all, (igraph_real_t) x);
	VECTOR(realization_star)[ x ] = 1;

	if (PRINT_TESTING_OPTION) {
		print_realization_vector(&realization_star, n);
	}

	clear_vector_idx(&q_infected_nodes_all, &realization_star);
	if (PRINT_TESTING_OPTION) {
		print_realization_vector(&realization_star, n);
	}

	int q_size = (int) igraph_dqueue_size(&q_infected_nodes_all);
	int r_size = (int) igraph_vector_sum( &realization_star );

	if ((q_size == 0) && (r_size == 0)){
		if (PRINT_TESTING_OPTION) {
			printf("Test: test_clear_realization_with_vector is: OK ! \n");
		}
		return 1;
	}else{
		if (PRINT_TESTING_OPTION) {
			printf("Test: test_clear_realization_with_vector is: NOT PASSED **** \n");
		}
		return -1;
	}

	igraph_vector_destroy(&realization_star);
	igraph_dqueue_destroy(&q_infected_nodes_all);
}

void print_realization_vector(igraph_vector_t * realization, int size){
	printf("\n");
	for(int i = 0; i < size; ++i){
		int state = (int) VECTOR(*realization)[i];
		printf("%d ", state);
	}
	printf("\n");
}

void test_dirac_normalization(){

	double sigma = 0.1;
	double norm = general_dirac_norm( sigma );
	printf("norm %lf, expected 0.0886227 \n", norm);

	double norm_2 = (double) 1.0 / general_dirac_norm(sigma);
	printf("normalization constatnt %lf \n", norm_2);

}

void export_realizations_to_file(int argc, char **argv){

	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);

	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure
	p_infected_parameters->start_node = 10;

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = NAIVE_SIR_UNWEIGHTED_NET;

	printf("Generationg realizations ... \n");
	generate_realizations_for_export(&statistic_parameters, p_infected_parameters, &epidemicParameters );
	printf("Realizations done ! \n");

	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );

}

void test_uniform_randomization(int argc, char **argv){

	input input_args; //***HEAP-MEMORY SAFE
	read_input_arguments(argc, argv, &input_args);

	contagion_param_struct epidemicParameters;
	set_epidemic_parameters(&input_args, &epidemicParameters);

	infected_structure * p_infected_parameters; //***HEAP-MEMORY SAFE
	p_infected_parameters = (infected_structure *) malloc(sizeof (infected_structure));
	init_infected_structure(&input_args, p_infected_parameters); // read graphs structure
	p_infected_parameters->start_node = 10;
	p_infected_parameters->delta = 60;

	statistics statistic_parameters; //***HEAP-MEMORY SAFE
	init_statistic_parameters(1, 1, &input_args, p_infected_parameters, &statistic_parameters);
	statistic_parameters.contagion_process_type = LAZY_RECOVERY_SIR_TEMPORAL_NET;

	printf("run randomization ...\n");
	randomize_temporal_contacts_uniformly(p_infected_parameters, 300, 0);

	clear_epidemic_parameters(&epidemicParameters);
	destroy_statistic_parameters(&statistic_parameters);
	destroy_infected_structure(p_infected_parameters);
	free(p_infected_parameters);
	clear_input_arguments( &input_args );
}
